<?php

namespace Database\Seeders;

use App\Models\Tax;
use App\Models\User;
use Illuminate\Database\Seeder;

class TaxSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (Tax::count() !== 0) {
            return;
        }

        Tax::create(
            [
                'tax_title' => 'Zero tax',
                'tax_rate' => 0,
                'is_vat' => false,
                'is_tax_fix' => false,
                'tax_id' => '',
                'is_tax_included' => false,
            ]
        );
        Tax::create(
            [
                'tax_title' => 'VAT 17%',
                'tax_rate' => 17,
                'is_vat' => true,
                'is_tax_fix' => false,
                'tax_id' => '',
                'is_tax_included' => false,
            ]
        );
        Tax::create(
            [
                'tax_title' => 'GST 11%',
                'tax_rate' => 11,
                'is_vat' => false,
                'is_tax_fix' => false,
                'tax_id' => '',
                'is_tax_included' => false,
            ]
        );
    }
}
