<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('food_item_attributes', function (Blueprint $table) {
            $table->id();
            $table->string('uuid');
            $table->string('sku');
            $table->string('name');
            $table->float('price')->default(1);
            $table->float('cost')->default(0);
            $table->foreignId('food_item_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('food_item_attributes');
    }
};
