<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFoodItemsTable extends Migration
{
    public $table = 'food_items';
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('food_items', function (Blueprint $table) {
            $table->id();
            $table->string('uuid');
            $table->string('sku');
            $table->string('name');
            $table->float('price')->default(1);
            $table->float('cost')->default(0);
            $table->string('image')->nullable();
            $table->foreignId('food_category_id')->constrained('food_categories');
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('food_items_ingredients', function (Blueprint $table) {
            $table->dropForeign(['food_item_id']);
        });
        Schema::dropIfExists('food_items');
    }
}
