<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class UserActivityLogFilter extends ModelFilter
{

    public $relations = [];

    public function search($search): UserActivityLogFilter
    {
        return $this->where('activity', 'LIKE', '%' . $search . '%')
            ->orWhere('ip', 'LIKE', '%' . $search . '%')
            ->orWhere('device', 'LIKE', '%' . $search . '%')
            ->orWhere('link', 'LIKE', '%' . $search . '%');
    }

    public function user($user): UserActivityLogFilter
    {
        return $this->where('user_id', $user);
    }

}
