<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class SaleItemFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string         $search  The search
     *
     * @return     SaleItemFilter  The product filter.
     */
    public function search($search): SaleItemFilter
    {
        return $this->where('item_name', 'LIKE', '%' . $search . '%');
    }

    /**
     * Filtter by category
     *
     * @param      string       $category  The category
     *
     * @return     SaleItemFilter  The product filter.
     */
    public function category($category): SaleItemFilter
    {
        return $this->where('food_category_id', $category);
    }

    /**
     * Filtering by by day
     *
     * @param      mixed           $isDuration  The duration
     *
     * @return     SaleItemFilter  The repair order filter.
     */
    public function isDuration($isDuration): SaleItemFilter
    {
        if ('day' == $isDuration) {
            return $this->whereDay('created_at', '=', date('d'));
        }
        if ('month' == $isDuration) {
            return $this->whereMonth('created_at', '=', date('m'));
        }
        if ('year' == $isDuration) {
            return $this->whereYear('created_at', '=', date('Y'));
        }
        return $this;
    }

    /**
     * Filtering by starting date
     *
     * @param      mixed            $startdate  The startdate
     *
     * @return     SaleItemFilter  The repair order filter.
     */
    public function startdate($startdate): SaleItemFilter
    {
        return $this->where('created_at', '>=', $startdate);
    }

    /**
     * Filtering by ending date date
     *
     * @param      mixed        $period  The period
     *
     * @return     SaleItemFilter  The repair order filter.
     */
    public function enddate($enddate): SaleItemFilter
    {
        return $this->where('created_at', '<=', $enddate);
    }

    public function starttime($starttime): SaleItemFilter
    {
        return $this->whereTime('created_at', '>=', $starttime);
    }

    public function endtime($endtime): SaleItemFilter
    {
        return $this->whereTime('created_at', '<=', $endtime);
    }
}
