<?php

namespace App\Imports;

use App\Models\PickupPoint;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class PickupPointsImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new PickupPoint([
            'place_title' => $row['place_title'],
            'person_name' => $row['person_name'] ?? null,
            'phone' => $row['phone'] ?? null,
            'address' => $row['address'] ?? null,
        ]);
    }

    public function rules(): array
    {
        return [
            'place_title' => 'required|unique:pickup_points,place_title',
            'person_name' => 'nullable',
            'phone' => 'nullable',
            'addrress' => 'address',
        ];
    }
}
