<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PosTaxResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'tax_title' => $this->tax_title,
            'rate' => $this->tax_rate,
            'tax_rate' => $this->tax_rate,
            'is_vat' => $this->is_vat,
            'is_tax_fix' => $this->is_tax_fix,
            'tax_id' => $this->tax_id,
            'is_tax_included' => $this->is_tax_included,
        ];
    }
}
