<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TaxStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'tax_title' => 'required|string|max:50',
            'tax_rate' => 'required|numeric',
            'is_tax_included' => 'boolean',
            'is_tax_fix' => 'boolean',
            'tax_id' => 'sometimes',
            'is_vat' => 'required',
        ];
    }
}
