<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Resources\ActivityLogResource;
use App\Models\UserActivityLog;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class UserActivityLogController extends ApiController
{

    public function __construct()
    {
        $this->middleware(['auth:sanctum']);
    }

    public function getAllLogs(Request $request): JsonResponse
    {
        $sort = $this->sort($request);
        $logs = UserActivityLog::filter($request->all())
            ->orderBy($sort['column'], $sort['order'])
            ->paginate((int) $request->get('perPage', 10));
        return response()->json(
            [
                'items' => ActivityLogResource::collection($logs->items()),
                'pagination' => $this->pagination($logs),
            ]
        );
    }

    public function getMyLogs(): JsonResponse
    {
        $logs = UserActivityLog::latest()->limit(50)->get();
        return response()->json(ActivityLogResource::collection($logs));
    }
}
