<?php

namespace App\Helpers;

use App\Models\UserActivityLog;

class ActivityLogger
{
    public static function log($activity, $link = null)
    {
        // Log user activity
        UserActivityLog::create([
            'user_id' => auth()->id(),
            'device' => request()->header('User-Agent'), // Fetch device information from request headers
            'ip' => request()->ip(), // Fetch IP address from request
            'activity' => $activity,
            'link' => $link,
        ]);
    }
}
