<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SalesExport implements FromCollection, WithHeadings
{
    public $orders = [];

    public function __construct($orders)
    {
        $this->orders = $orders;
    }

    public function headings(): array
    {
        return [
            'uuid', 'tracking', 'order_type', 'tax_amount', 'cart_total_items', 'cart_total_price',
            'cart_total_cost', 'profit_after_all', 'payable_after_all', 'discount_amount', 'is_preparing', 'prepared_at', 'after_discount',
            'completed_at', 'payment_note', 'progress', 'created_at', 'updated_at', 'tip_amount', 'is_paid',
        ];
    }
    public function collection()
    {
        return $this->orders->makeHidden([
            'id', 'items', 'tax', 'subtotal',  'discount_rate', 'table_id', 'order_taker_id',
            'took_at', 'chef_id', 'customer_id', 'ordered_online', 'biller_id', 'staff_note',
            'payment_method_id', 'note_for_chef', 'is_cancelled', 'cancellation_reason', 'is_discount_in_percentage',
            'shipping_address', 'pickup_point_id', 'cash_book_id', 'guest_room_reservation_id',
        ]);
    }
}
