<?php

namespace App\Exports;

use App\Models\PickupPoint;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class PickupPointsExport implements FromCollection, WithHeadings
{
    public function headings(): array
    {
        return [
            'place_title', 'person_name', 'phone', 'address',
        ];
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return PickupPoint::all()->makeHidden([
            'id',
            'created_at',
            'updated_at',
        ]);
    }
}
