<?php

namespace App\Exports;

use App\Models\GuestRoom;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GuestRoomsExport implements FromCollection, WithHeadings
{
    public function headings(): array
    {
        return [
            'room_name',
            'capactity',
            'per_hour_charges'
        ];
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return GuestRoom::all()->makeHidden([
            'id',
            'layout',
            'availability', 'images',
            'created_at',
            'updated_at',
        ]);
    }
}
